/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class VisitorDataView
extends CitizenDataView
implements IVisitorViewData {
    private final IColonyView colony;
    private ItemStack recruitmentCosts;
    private UUID textureUUID;
    private ResourceLocation cachedTexture;

    public VisitorDataView(int id, IColonyView colony) {
        super(id);
        this.colony = colony;
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        super.deserialize(buf);
        this.recruitmentCosts = buf.func_150791_c();
        if (buf.readBoolean()) {
            this.textureUUID = buf.func_179253_g();
        }
    }

    @Override
    public IColonyView getColonyView() {
        return this.colony;
    }

    @Override
    public ItemStack getRecruitCost() {
        return this.recruitmentCosts;
    }

    @Override
    public ResourceLocation getCustomTexture() {
        if (this.textureUUID == null) {
            return null;
        }
        if (this.cachedTexture == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            GameProfile profile = new GameProfile(this.textureUUID, VisitorDataView.getNameFromUUID(this.textureUUID));
            profile = SkullTileEntity.func_174884_b((GameProfile)profile);
            Map map = minecraft.func_152342_ad().func_152788_a(profile);
            if (!map.isEmpty()) {
                this.cachedTexture = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            }
        }
        return this.cachedTexture == null ? DefaultPlayerSkin.func_177334_a((UUID)this.textureUUID) : this.cachedTexture;
    }

    private static String getNameFromUUID(UUID uuid) {
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL("https://api.mojang.com/user/profiles/" + uuid.toString() + "/names").openConnection().getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            JsonArray json = (JsonArray)new Gson().fromJson(response.toString(), JsonArray.class);
            return json.get(json.size() - 1).getAsJsonObject().get("name").getAsString();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

